<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Absences</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-900 flex">

    <!-- Sidebar -->
    <?php 
    session_start();
    include('sidebar.php'); 
    ?>

    <!-- Overlay (for mobile) -->
    <div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-20 hidden"></div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col relative">
        <!-- Mobile Header -->
        <div class="p-4 lg:hidden fixed top-0 left-0 w-full bg-[#f2f6fa] z-40 shadow-md">
            <button id="menu-button" class="text-blue-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16m-7 6h7" />
                </svg>
            </button>
        </div>
        <?php
        $requete = "SELECT * FROM retards_absences";
        $stmt = $db->query($requete);
        $absences = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>

        <div class="flex flex-col h-screen w-full py-6 md:px-12 md:py-12 overflow-y-auto relative">

            <h1 class="text-center text-3xl font-bold mb-4">Absences</h1>
            <p class="text-center text-gray-600 mb-6">Vous retrouverez ci-dessous un récapitulatif de vos absences. Il est actualisé de manière hebdomadaire. Veuillez contacter le secrétariat pour toutes questions.</p>
            <p class="text-center text-sm font-bold mb-4">*Cliquez sur une absence pour la justifier</p>


            <div class="space-y-4">
                        <?php
                        foreach ($absences as $absence) {
                        echo"
                <div class='flex items-center p-4 bg-white shadow rounded-lg cursor-pointer' onclick='showPopup('{$absence['nom_matiere']}', '{$absence['date']}', '{$absence['temps']}h : absence élève')'>
                    <div class='bg-blue-500 text-white rounded-full w-12 h-12 flex items-center justify-center mr-4'>{$absence['date']}</div>
                        <div>
                        
                            <p class='font-bold'>{$absence['nom_matiere']}</p>
                            <p class='text-sm text-gray-600'>{$absence['temps']}h : absence élève</p>
                            ";
                            }
                            ?>
                        </div>
                </div>
            </div>
        </div>
        ?>
        <!-- Popup Justification -->
        <!-- Popup Justification -->
<div id="popup" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-lg shadow-lg p-6 w-11/12 md:w-1/2 relative">
        <button class="absolute top-2 right-2 text-gray-400 hover:text-gray-600" onclick="hidePopup()">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
            </svg>
        </button>
        <h2 class="text-2xl font-bold text-center mb-6">Justifier son absence</h2>
        
        <div class="mb-6 text-center">
            <p class="text-gray-700 font-medium text-sm" id="absence-details">Absence sélectionnée : </p>
        </div>

        <div class="form-control mb-6">
            <label class="label">
                <span class="label-text font-bold">Joindre un fichier :</span>
            </label>
            <input type="file" class="file-input file-input-bordered w-full" />
        </div>

        <div class="form-control mb-6">
            <label class="label">
                <span class="label-text font-bold">Message (facultatif) :</span>
            </label>
            <textarea class="textarea textarea-bordered w-full" placeholder="Ajouter un message"></textarea>
        </div>

        <div class="flex justify-between">
            <button class="btn btn-outline btn-error" onclick="hidePopup()">Annuler</button>
            <button class="btn btn-success">Valider</button>
        </div>
    </div>
</div>

    </div>

    <script>
        // Gestion de la sidebar
        const menuButton = document.getElementById('menu-button');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        menuButton.addEventListener('click', () => {
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });

        // Popup Logic
        function showPopup(subject, date, duration) {
            document.getElementById('absence-details').textContent = `${subject} - ${date} (${duration})`;
            document.getElementById('popup').classList.remove('hidden');
        }

        function hidePopup() {
            document.getElementById('popup').classList.add('hidden');
        }
    </script>

</body>
</html>
