<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-900 flex">

    <!-- Sidebar -->
    <?php 
    session_start();
    include('sidebar.php');
    ?>

    <!-- Overlay for Mobile -->
    <div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-20 hidden"></div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col relative">
        <!-- Mobile Header -->
        <div class="p-4 lg:hidden fixed top-0 left-0 w-full bg-white z-40 shadow-md flex justify-between items-center">
            <button id="menu-button" class="text-blue-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16m-7 6h7" />
                </svg>
            </button>
            <h1 class="text-xl font-bold">Administration</h1>
        </div>

        <!-- Administration Content -->
        <div class="flex flex-col h-screen w-full py-6 px-4 md:px-12 md:py-12 overflow-y-auto relative">
            <!-- Title -->
            <h1 class="text-center text-3xl font-bold mb-6">Administration</h1>

            <!-- Sections -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Notes Section -->
                <div class="bg-white shadow-lg rounded-lg p-6">
                    <div class="flex justify-between items-center">
                        <h2 class="text-lg font-bold">Récapitulatif des notes</h2>
                        <a href="note.php" class="text-blue-500 hover:text-blue-700">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7" />
                            </svg>
                        </a>
                    </div>
                    <div class="mt-4 space-y-2">
                        <?php
                        if (!isset($_SESSION['login'])) {
                            echo "<p>Vous devez être connecté pour voir cette page.</p>";
                            exit;
                        }

                        $id_user = $_SESSION['id_user'];
                        include 'conn.php';
                        $requete = "SELECT * FROM notes WHERE id_utilisateur = :id_user";
                        $stmt = $db->prepare($requete);
                        $stmt->bindParam(':id_user', $id_user, PDO::PARAM_INT);
                        $stmt->execute();
                        $notes = $stmt->fetchAll(PDO::FETCH_ASSOC);

                        foreach ($notes as $note) {
                            echo "<div class='flex items-center justify-between bg-gray-100 p-4 rounded-lg'>";
                            echo "<div class='text-blue-500 font-bold'>" . $note['note'] . "/20</div>";
                            echo "<div><p class='font-semibold'>" . $note['nom_matiere'] . "</p><p class='text-sm text-gray-600'>Date : " . $note['date'] . "</p></div>";
                            echo "</div>";
                        }
                        ?>
                    </div>
                </div>

                <!-- Absences Section -->
                <div class="bg-white shadow-lg rounded-lg p-6">
                    <div class="flex justify-between items-center">
                        <h2 class="text-lg font-bold">Absences</h2>
                        <a href="absences.php" class="text-blue-500 hover:text-blue-700">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7" />
                            </svg>
                        </a>
                    </div>
                    <div class="mt-4 space-y-2">
                        <?php
                        $requete = "SELECT * FROM retards_absences WHERE id_user = :id_user";
                        $stmt = $db->prepare($requete);
                        $stmt->bindParam(':id_user', $id_user, PDO::PARAM_INT);
                        $stmt->execute();
                        $absences = $stmt->fetchAll(PDO::FETCH_ASSOC);

                        foreach ($absences as $absence) {
                            echo "<div class='flex items-center justify-between bg-gray-100 p-4 rounded-lg'>";
                            echo "<div class='bg-blue-500 text-white rounded-full w-12 h-12 flex items-center justify-center'>" . $absence['date'] . "</div>";
                            echo "<div><p class='font-semibold'>" . $absence['nom_matiere'] . "</p><p class='text-sm text-gray-600'>" . $absence['temps'] . "h : absence élève</p></div>";
                            echo "</div>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript for Sidebar -->
    <script>
        const menuButton = document.getElementById('menu-button');
        const sidebar = document.querySelector('aside');
        const overlay = document.getElementById('overlay');

        menuButton.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
            overlay.classList.toggle('hidden');
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });
    </script>
</body>
</html>
