<?php
include 'conn.php';
session_start();

// Vérification des données envoyées via POST
if (
    isset($_POST["note"], $_POST["coeff"], $_POST["date"], $_POST["eleve"], $_POST['matiere']) &&
    !empty($_POST["note"]) &&
    !empty($_POST["coeff"]) &&
    !empty($_POST["date"]) &&
    !empty($_POST["eleve"]) &&
    !empty($_POST["matiere"]) 
) {
    try {
        $id_matiere = $_SESSION['id_matiere']; 

        // Préparation de la requête pour insérer une note
        $requete = "INSERT INTO notes (id_note, note, coeff, date, id_utilisateur, id_matiere, nom_matiere) 
        VALUES (NULL, :note, :coeff, :date, :id_user, :id_matiere, :nom_matiere)";
        $stmt = $db->prepare($requete);

        // Liaison des valeurs
        $stmt->bindValue(':note', $_POST["note"], PDO::PARAM_STR);
        $stmt->bindValue(':coeff', $_POST["coeff"], PDO::PARAM_STR);
        $stmt->bindValue(':date', $_POST["date"], PDO::PARAM_STR);
        $stmt->bindValue(':id_user', $_POST['eleve'], PDO::PARAM_INT); // Utilisation de l'id_user récupéré
        $stmt->bindValue(':nom_matiere', $_POST['matiere'], PDO::PARAM_STR);
        $stmt->bindValue(':id_matiere', $id_matiere, PDO::PARAM_INT);

        // Exécution de la requête
        $stmt->execute();

        // Redirection après succès
        header('Location: espace-administrateur.php');
        exit;
    } catch (PDOException $e) {
        // Gestion des erreurs
        echo "Erreur lors de l'insertion : " . $e->getMessage();
    }
} else {
    // Si des données sont manquantes ou invalides
    echo "Veuillez remplir tous les champs correctement.";
}
?>
