<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmation d'envoi</title>
    <style>
        /* Ajout pour garantir que le body et html occupent 100% de la hauteur */
        html, body {
            height: 100%;
            margin: 0;
        }
    </style>
    <script src="https://unpkg.com/@dotlottie/player-component@2.7.12/dist/dotlottie-player.mjs" type="module"></script>
</head>
<body class="bg-background text-h1 relative">
<?php include('header.php'); ?>

<!-- Lien "Retour à la connexion" en haut à droite pour les écrans moyens et plus -->
<a href="/connexion/login.php" class="hidden md:block absolute top-4 right-6 text-button text-sm hover:underline">
    Retour à la connexion
</a>

<div class="flex items-center justify-center h-full w-full">
    <!-- Conteneur principal -->
    <div class="bg-card-background w-full md:w-9/12 lg:w-8/12 max-w-4xl h-full md:h-auto p-6 md:p-12 rounded-none md:rounded-lg shadow-lg text-center flex flex-col justify-between">
        <!-- Titre -->
        <h1 class="text-3xl md:text-4xl font-bold mt-2 md:mt-6">Un mail vient de vous être envoyé</h1>

        <!-- Animation Lottie -->
        <div class="flex items-center justify-center mt-6">
            <dotlottie-player 
                src="https://lottie.host/d2b1e45f-2f05-4539-968c-e4077e34d260/jk9hf2zCFX.json" 
                background="transparent" 
                speed="1" 
                style="width: 350px; height: 350px" 
                direction="1" 
                playMode="normal" 
                autoplay>
            </dotlottie-player>
        </div>

        <!-- Lien "Retour à la connexion" en bas sur mobile -->
        <a href="connect.php" class="block md:hidden text-button text-lg hover:underline mb-4">
            Retour à la connexion
        </a>
    </div>
</div>

</body>
</html>
