<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Emploi du temps</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        html, body {
            height: 100%;
            margin: 0;
        }
    </style>
</head>
<body class="bg-background text-h1">

<?php 
    session_start();
    include('sidebar.php');
    include('header.php'); 
?>

<div class="flex h-screen">
    <!-- Conteneur pour la sidebar (déjà incluse dans `sidebar.php`) -->
    <!-- La sidebar utilise `fixed`, elle ne prend pas de place dans le flux normal, donc pas besoin de div supplémentaire -->

    <!-- Conteneur principal de l'emploi du temps -->
    <div class="flex flex-col flex-1 py-6 md:px-12 md:py-12 overflow-y-hidden relative">
        <!-- Titre -->
        <h1 class="text-center text-3xl font-bold mb-6">Emploi du temps</h1>

        <!-- Boutons de navigation (format mobile) -->
        <div class="flex justify-between items-center mb-4 px-4 md:hidden">
            <button class="bg-blue-500 text-white h-12 w-12 rounded-full shadow-md flex items-center justify-center">
                &larr;
            </button>
            <button class="bg-blue-500 text-white h-12 w-12 rounded-full shadow-md flex items-center justify-center">
                &rarr;
            </button>
        </div>

        <!-- Boutons de navigation (format desktop) -->
        <button class="hidden md:flex items-center justify-center absolute h-12 w-12 left-20 bottom-5 bg-blue-500 text-white rounded-full shadow-md">
            &larr;
        </button>
        <button class="hidden md:flex items-center justify-center absolute h-12 w-12 right-20 bottom-5 bg-blue-500 text-white rounded-full shadow-md">
            &rarr;
        </button>

        <!-- Conteneur principal -->
        <div class="flex-1 flex overflow-y-hidden overflow-x-auto md:overflow-x-hidden">
            <!-- Colonne des heures -->
            <div class="sticky left-0 bg-gray-100 border-r border-gray-300 text-center z-10 w-16">
                <div class="h-[10%] flex items-center justify-center text-gray-500">9h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">10h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">11h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">12h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">13h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">14h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">15h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">16h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">17h</div>
                <div class="h-[10%] flex items-center justify-center text-gray-500">18h</div>
            </div>

            <!-- Colonnes des jours -->
            <div class="grid grid-cols-5 gap-0 md:gap-4 flex-shrink-0 w-max md:w-full">
                <!-- Lundi -->
                <div class="border border-gray-300 w-[90vw] md:w-auto">
                    <div class="bg-button text-titre text-center py-2 font-bold">Lundi</div>
                    <div class="relative h-full">
                        <div class="absolute top-[10%] h-[20%] left-1/2 transform -translate-x-1/2 w-[90%] md:w-[90%] bg-card-ent-js rounded-md text-white p-2 flex flex-col justify-between">
                            <p class="font-bold">JavaScript</p>
                            <p class="text-sm text-right">Salle 119</p>
                        </div>
                    </div>
                </div>

                <!-- Mardi -->
                <div class="border border-gray-300 w-[90vw] md:w-auto">
                    <div class="bg-button text-titre text-center py-2 font-bold">Mardi</div>
                    <div class="relative h-full">
                        <div class="absolute top-[10%] h-[10%] left-1/2 transform -translate-x-1/2 w-[90%] md:w-[90%] bg-card-ent-devw rounded-md text-white p-2 flex flex-col justify-between">
                            <p class="font-bold">Développement Web</p>
                            <p class="text-sm text-right">Salle 120</p>
                        </div>
                        <div class="absolute top-[30%] h-[20%] left-1/2 transform -translate-x-1/2 w-[90%] md:w-[90%] bg-card-ent-eng rounded-md text-white p-2 flex flex-col justify-between">
                            <p class="font-bold">Motion Design</p>
                            <p class="text-sm text-right">Salle 126</p>
                        </div>
                    </div>
                </div>

                <!-- Mercredi -->
                <div class="border border-gray-300 w-[90vw] md:w-auto">
                    <div class="bg-button text-titre text-center py-2 font-bold">Mercredi</div>
                    <div class="relative h-full">
                        <div class="absolute top-[50%] h-[10%] left-1/2 transform -translate-x-1/2 w-[90%] md:w-[90%] bg-card-ent-uiux rounded-md text-white p-2 flex flex-col justify-between">
                            <p class="font-bold">UX/UI</p>
                            <p class="text-sm text-right">Salle 124</p>
                        </div>
                    </div>
                </div>

                <!-- Jeudi -->
                <div class="border border-gray-300 w-[90vw] md:w-auto">
                    <div class="bg-button text-titre text-center py-2 font-bold">Jeudi</div>
                </div>

                <!-- Vendredi -->
                <div class="border border-gray-300 w-[90vw] md:w-auto">
                    <div class="bg-button text-titre text-center py-2 font-bold">Vendredi</div>
                    <div class="relative h-full">
                        <div class="absolute top-[20%] h-[20%] left-1/2 transform -translate-x-1/2 w-[90%] md:w-[90%] bg-card-ent-auto rounded-md text-white p-2 flex flex-col justify-between">
                            <p class="font-bold">Autonomie</p>
                            <p class="text-sm text-right">Salle 128</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Période -->
        <div class="text-center font-bold mt-4">
            Semaine du XX mois au XX mois
        </div>
    </div>
</div>

</body>
</html>
