<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Restauration</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-900 flex">

    <!-- Sidebar -->
    <?php
    session_start();
    include('sidebar.php'); 
    ?>

    <!-- Overlay (for mobile) -->
    <div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-20 hidden"></div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col relative">
        <!-- Mobile Header -->
        <header class="p-4 lg:hidden fixed top-0 left-0 w-full bg-white z-40 shadow-md flex items-center justify-between">
            <button id="menu-button" class="text-blue-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16m-7 6h7" />
                </svg>
            </button>
            <h1 class="text-lg font-bold">Restauration</h1>
        </header>

        <!-- Header for Larger Screens -->
        <header class="hidden lg:block bg-white shadow-md w-full p-4">
            <h1 class="text-2xl font-bold text-center">Restauration</h1>
        </header>

        <!-- Page Content -->
        <main class="flex-1 p-6 md:p-12 space-y-8 mt-16 lg:mt-0">
            <!-- Section Cantines Crous -->
            <section class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h2 class="text-lg font-semibold mb-4">Cantines Crous à Proximité</h2>
                    <div class="space-y-4">
                        <div class="bg-white rounded-lg shadow p-4 flex items-center justify-between">
                            <span class="font-medium">Copernic</span>
                            <button class="bg-gray-200 rounded-full p-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-700" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 5v14m-7-7h14" />
                                </svg>
                            </button>
                        </div>
                        <div class="bg-white rounded-lg shadow p-4 flex items-center justify-between">
                            <span class="font-medium">ESIEE</span>
                            <button class="bg-gray-200 rounded-full p-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-700" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 5v14m-7-7h14" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Section Horaires Cafétéria -->
                <div class="md:col-span-2">
                    <h2 class="text-lg font-semibold mb-4 text-center md:text-left">Horaires Cafétéria</h2>
                    <div class="bg-white rounded-lg shadow p-6 flex flex-col items-center md:flex-row md:justify-between">
                        <div class="text-center md:text-left">
                            <p class="font-medium">Cafet IUT Marne la Vallée</p>
                            <p class="text-green-600 font-semibold">OUVERT</p>
                            <p class="text-gray-600">11h - 14h30</p>
                        </div>
                        <div class="mt-4 md:mt-0">
                            <div class="bg-blue-500 text-white font-bold text-lg rounded-full w-16 h-16 flex items-center justify-center mx-auto md:mx-0">
                                15 MIN
                            </div>
                            <p class="text-gray-600 text-sm text-center mt-2">Temps d'attente approximatif</p>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Bouton Voir le Menu du Jour -->
            <div id="startSection" class="text-center">
                <button id="menuButton" class="bg-blue-500 text-white px-6 py-3 rounded-lg shadow-md hover:bg-blue-600">
                    Voir le menu du jour
                </button>
            </div>

            <!-- Section Menu du Jour -->
            <section id="menuSection" class="hidden space-y-6">
                <div class="flex justify-between items-center">
                    <button id="backButton" class="text-blue-500 hover:underline">
                        &larr; Retour
                    </button>
                    <h2 class="text-lg font-semibold text-center">Menu du jour</h2>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="bg-white rounded-lg shadow p-6">
                        <h3 class="text-blue-600 font-bold">CROUS : IUT</h3>
                        <p>Entrée : Salade de pâtes / Sardines</p>
                        <p>Plat : Poulet & pommes de terre</p>
                        <p>Dessert : Salade de fruit</p>
                    </div>
                    <div class="bg-white rounded-lg shadow p-6">
                        <h3 class="text-blue-600 font-bold">Sandwich : IUT</h3>
                        <p>Entrée : Pomme / Salade</p>
                        <p>Plat : Sandwich / Panini</p>
                        <p>Dessert : Yaourt / Madeleine</p>
                    </div>
                    <div class="bg-white rounded-lg shadow p-6">
                        <h3 class="text-blue-600 font-bold">Pasta : IUT</h3>
                        <p>Entrée : Pomme / Salade</p>
                        <p>Plat : Pasta Box / Pâtes carbonara</p>
                        <p>Dessert : Yaourt / Madeleine</p>
                    </div>
                </div>
                <div class="text-center">
                    <button id="startButton" class="bg-black text-white px-6 py-3 rounded-lg shadow-md hover:bg-gray-800">
                        COMMANDER
                    </button>
                </div>
            </section>

            <!-- Section CROUS Bar -->
            <section id="step1" class="hidden space-y-6 text-center">
                <h2 class="text-2xl font-bold">Sélectionnez le CROUS BAR le plus proche de vous</h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <button class="bg-red-500 text-white font-bold rounded-lg py-6 px-4 hover:bg-red-700" id="validateButton1">ESIEE</button>
                    <button class="bg-red-500 text-white font-bold rounded-lg py-6 px-4 hover:bg-red-700" id="validateButton2">IUT</button>
                    <button class="bg-red-500 text-white font-bold rounded-lg py-6 px-4 hover:bg-red-700" id="validateButton3">COPERNIC</button>
                </div>
            </section>

            <!-- Confirmation -->
            <section id="step2" class="hidden text-center space-y-6">
                <h2 class="text-2xl font-bold">Votre menu a été réservé</h2>
                <p>Bon appétit ! Récupérez votre commande au CROUS choisi.</p>
            </section>
        </main>
    </div>

    <script>
        // Sidebar gestion
        const menuButton = document.getElementById('menu-button');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        menuButton.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
            overlay.classList.toggle('hidden');
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });

        // Navigation entre les étapes
        const menuBtn = document.getElementById('menuButton');
        const backButton = document.getElementById('backButton');
        const startButton = document.getElementById('startButton');
        const validateButtons = document.querySelectorAll('#step1 button');

        const startSection = document.getElementById('startSection');
        const menuSection = document.getElementById('menuSection');
        const step1 = document.getElementById('step1');
        const step2 = document.getElementById('step2');

        menuBtn.addEventListener('click', () => {
            menuSection.classList.remove('hidden');
            startSection.classList.add('hidden');
        });

        backButton.addEventListener('click', () => {
            menuSection.classList.add('hidden');
            startSection.classList.remove('hidden');
        });

        startButton.addEventListener('click', () => {
            menuSection.classList.add('hidden');
            step1.classList.remove('hidden');
        });

        validateButtons.forEach(button => {
            button.addEventListener('click', () => {
                step1.classList.add('hidden');
                step2.classList.remove('hidden');
            });
        });
    </script>
</body>
</html>
