<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paramètres</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        html, body {
            height: 100%;
            margin: 0;
        }
    </style>
</head>
<body class="bg-gray-100 text-gray-900 min-h-screen flex">
<?php
session_start();
include 'sidebar.php';
?>
        <!-- Settings -->
        <div class="py-6 border-t">
            <a href="#" class="flex items-center justify-center text-lg font-medium hover:text-blue-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m1 8a9 9 0 11-6 0m1-3h4m2 0h4" />
                </svg>
                Paramètres
            </a>
        </div>
    </div>

    <!-- Overlay (for mobile) -->
    <div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-20 hidden"></div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col">

        <!-- Header -->
        <div class="p-4 lg:hidden">
            <button id="menu-button" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16m-7 6h7" />
                </svg>
            </button>
        </div>

        <!-- Contenu -->
        <div class="p-6">
            <h1 class="text-2xl md:text-4xl font-bold mb-6">Paramètres</h1>

            <!-- Layout pour les paramètres -->
            <div class="flex flex-col md:flex-row gap-6">
                <!-- Menu de navigation -->
                <div class="bg-white shadow-md rounded-lg p-4 w-full md:w-52">
                    <ul class="space-y-4">
                        <li>
                            <button id="personalization-tab" class="w-full text-left py-2 px-3 rounded-lg hover:bg-gray-100 focus:outline-none focus:ring focus:ring-indigo-200 bg-indigo-100 text-indigo-700">
                                Personnalisation
                            </button>
                        </li>
                        <li>
                            <button id="accessibility-tab" class="w-full text-left py-2 px-3 rounded-lg hover:bg-gray-100 focus:outline-none focus:ring focus:ring-indigo-200">
                                Accessibilité
                            </button>
                        </li>
                    </ul>
                </div>

                <!-- Contenu principal -->
                <div id="content" class="bg-white shadow-md rounded-lg p-4 w-full md:w-96">
                    <!-- Par défaut : Personnalisation -->
                    <div id="personalization-content" class="space-y-4">
                        <h2 class="text-xl md:text-2xl font-bold mb-4">Personnalisation</h2>
                        <ul>
                            <li class="flex items-center gap-4 p-2 rounded-lg hover:bg-gray-100">
                                <span class="w-6 h-6 bg-purple-200 text-purple-700 flex items-center justify-center rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M12 1v22M1 12h22" />
                                    </svg>
                                </span>
                                <span>Changer la couleur d’arrière-plan</span>
                            </li>
                            <li class="flex items-center gap-4 p-2 rounded-lg hover:bg-gray-100">
                                <span class="w-6 h-6 bg-purple-200 text-purple-700 flex items-center justify-center rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M3 3h18v18H3z" />
                                    </svg>
                                </span>
                                <span>Modifier la taille de la police</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Accessibilité -->
                    <div id="accessibility-content" class="space-y-4 hidden">
                        <h2 class="text-xl md:text-2xl font-bold mb-4">Accessibilité</h2>
                        <ul>
                            <li class="flex items-center gap-4 p-2 rounded-lg hover:bg-gray-100">
                                <span class="w-6 h-6 bg-purple-200 text-purple-700 flex items-center justify-center rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M10 4H4v6h6V4zm6 6h6V4h-6v6zM4 14h6v6H4v-6zm12 0h6v6h-6v-6z" />
                                    </svg>
                                </span>
                                <span>Contraste</span>
                            </li>
                            <li class="flex items-center gap-4 p-2 rounded-lg hover:bg-gray-100">
                                <span class="w-6 h-6 bg-purple-200 text-purple-700 flex items-center justify-center rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M3 3h18v18H3z" />
                                    </svg>
                                </span>
                                <span>Taille de la police</span>
                            </li>
                            <li class="flex items-center gap-4 p-2 rounded-lg hover:bg-gray-100">
                                <span class="w-6 h-6 bg-purple-200 text-purple-700 flex items-center justify-center rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M12 4v16m8-8H4" />
                                    </svg>
                                </span>
                                <span>Activer option de lecture audio</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        const menuButton = document.getElementById('menu-button');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        // Ouvrir la sidebar (mobile)
        menuButton.addEventListener('click', () => {
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        });

        // Fermer la sidebar en cliquant sur l'overlay
        overlay.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        });

        // Gestion du changement d'onglet
        const personalizationTab = document.getElementById('personalization-tab');
        const accessibilityTab = document.getElementById('accessibility-tab');
        const personalizationContent = document.getElementById('personalization-content');
        const accessibilityContent = document.getElementById('accessibility-content');

        personalizationTab.addEventListener('click', () => {
            personalizationContent.classList.remove('hidden');
            accessibilityContent.classList.add('hidden');
            personalizationTab.classList.add('bg-indigo-100', 'text-indigo-700');
            accessibilityTab.classList.remove('bg-indigo-100', 'text-indigo-700');
        });

        accessibilityTab.addEventListener('click', () => {
            accessibilityContent.classList.remove('hidden');
            personalizationContent.classList.add('hidden');
            accessibilityTab.classList.add('bg-indigo-100', 'text-indigo-700');
            personalizationTab.classList.remove('bg-indigo-100', 'text-indigo-700');
        });
    </script>
</body>
</html>
